// ستاره‌های متحرک ساده
const canvas = document.getElementById("star-bg");
const ctx = canvas.getContext("2d");
let stars = [];

function resize() {
  canvas.width = window.innerWidth;
  canvas.height = window.innerHeight;
}
window.addEventListener("resize", resize);
resize();

for (let i = 0; i < 100; i++) {
  stars.push({
    x: Math.random() * canvas.width,
    y: Math.random() * canvas.height,
    r: Math.random() * 2,
    s: Math.random() * 1 + 0.2
  });
}
function animate() {
  ctx.clearRect(0, 0, canvas.width, canvas.height);
  ctx.fillStyle = "#fff";
  for (let s of stars) {
    ctx.beginPath();
    ctx.arc(s.x, s.y, s.r, 0, Math.PI * 2);
    ctx.fill();
    s.y += s.s;
    if (s.y > canvas.height) s.y = 0;
  }
  requestAnimationFrame(animate);
}
animate();

// ---- پنل مدیریت ----
const loginBtn = document.getElementById("loginBtn");
const loginArea = document.getElementById("login-area");
const panelArea = document.getElementById("panel-area");

loginBtn.onclick = function() {
  const u = document.getElementById("user").value;
  const p = document.getElementById("pass").value;
  if (u === "38249792" && p === "7678") {
    loginArea.classList.add("hidden");
    panelArea.classList.remove("hidden");
    loadAdminNews();
  } else {
    alert("نام‌کاربری یا رمز عبور اشتباه است!");
  }
};

async function loadNews() {
  const res = await fetch("api/get_news.php");
  const list = await res.json();
  const container = document.getElementById("news-list");
  container.innerHTML = "";
  list.forEach(n => {
    let div = document.createElement("div");
    div.className = "news";
    div.innerHTML = `<h3>${n.title}</h3><p>${n.body}</p><img src="${n.image}" style="max-width:100%;border-radius:6px;">`;
    container.appendChild(div);
  });
}

async function loadAdminNews() {
  const res = await fetch("api/get_news.php");
  const list = await res.json();
  const container = document.getElementById("admin-news");
  container.innerHTML = "";
  list.forEach(n => {
    let div = document.createElement("div");
    div.className = "news";
    div.innerHTML = `<h4>${n.title}</h4>
    <button onclick="deleteNews(${n.id})">حذف</button>`;
    container.appendChild(div);
  });
}

document.getElementById("newsForm").onsubmit = async e => {
  e.preventDefault();
  const fd = new FormData();
  fd.append("title", document.getElementById("title").value);
  fd.append("body", document.getElementById("body").value);
  fd.append("image", document.getElementById("image").files[0]);
  const res = await fetch("api/add_news.php", { method: "POST", body: fd });
  if (await res.text() === "success") {
    alert("خبر اضافه شد!");
    loadNews();
    loadAdminNews();
  } else alert("خطا در ذخیره خبر");
};

async function deleteNews(id) {
  if (!confirm("حذف شود؟")) return;
  const fd = new FormData();
  fd.append("id", id);
  const res = await fetch("api/delete_news.php", { method: "POST", body: fd });
  if (await res.text() === "deleted") loadAdminNews();
}

loadNews();
